package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.UserAcceptExtTermsVerDTO;
import gov.va.med.mhv.admin.model.UserAcceptExtTermsVer;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class UserAcceptExtTermsVerConverter {

	public UserAcceptExtTermsVerDTO convertFrom(UserAcceptExtTermsVer t) {
		UserAcceptExtTermsVerDTO dto = new UserAcceptExtTermsVerDTO();
		dto.setId(t.getId());
		dto.setOplock(t.getOplock());
		dto.setUserProfileId(t.getUserProfileId());
		dto.setExtTermsConditionsEvent(t.getExtTermsCondEvent());
		dto.setExtTermsConditionsVer(t.getExtTermsCondVer());
		dto.setExtTermsConditionsNotes(t.getExtTermsCondVerNotes());
		dto.setCreatedDate(t.getCreatedDate());
		dto.setModifiedDate(t.getModifiedDate());
		dto.setAcceptedDate(t.getAcceptedDate());
		return dto;

	}

	public UserAcceptExtTermsVer convertTo(UserAcceptExtTermsVerDTO dto) {
		UserAcceptExtTermsVer t = new UserAcceptExtTermsVer();
		t.setId(dto.getId());
		t.setOplock(dto.getOplock());
		t.setUserProfileId(dto.getUserProfileId());
		t.setExtTermsCondEvent(dto.getExtTermsConditionsEvent());
		t.setExtTermsCondVer(dto.getExtTermsConditionsVer());
		t.setExtTermsCondVerNotes(dto.getExtTermsConditionsNotes());
		t.setCreatedDate(dto.getCreatedDate());
		t.setModifiedDate(dto.getModifiedDate());
		t.setAcceptedDate(dto.getAcceptedDate());
		return t;
	}

	public List<UserAcceptExtTermsVerDTO> convertList(List<UserAcceptExtTermsVer> userAcceptExtTermsVerList) {
		List<UserAcceptExtTermsVerDTO> list = new ArrayList<UserAcceptExtTermsVerDTO>();

		if (userAcceptExtTermsVerList != null) {
			for (UserAcceptExtTermsVer listItem : userAcceptExtTermsVerList) {
				UserAcceptExtTermsVerDTO dto = convertFrom(listItem);
				list.add(dto);
			}
		}

		return list;
	}

}
